---
title: Caching · Cloudflare Learning Paths
description: By default, Cloudflare caches static content such as images, CSS,
  and JavaScript. However, you can extend Cloudflare caching to work with HTML
  by creating custom Cache Rules.
lastUpdated: 2025-09-25T16:31:00.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/surge-readiness/performance/caching/
  md: https://developers.cloudflare.com/learning-paths/surge-readiness/performance/caching/index.md
---

## Optimize caching

By default, Cloudflare [caches static content](https://developers.cloudflare.com/cache/concepts/default-cache-behavior/) such as images, CSS, and JavaScript. However, you can extend Cloudflare caching to work with HTML by creating custom [Cache Rules](https://developers.cloudflare.com/cache/how-to/cache-rules/).

### Cache more requests

1. In the Cloudflare dashboard, go to the **Caching** > **Cache Rules** page.

   [Go to **Cache Rules**](https://dash.cloudflare.com/?to=/:account/:zone/caching/cache-rules)

2. Select **Create rule**.

3. For When incoming requests match, enter either your entire website or a specific path on your application, based on the Hostname or URI Path. Refer to the [available fields](https://developers.cloudflare.com/cache/how-to/cache-rules/settings/#fields).

4. For Cache eligibility, define how these requests should be cached and for how long. Refer to the available [cache eligibility settings](https://developers.cloudflare.com/cache/how-to/cache-rules/settings/#eligible-for-cache-settings).

5. You can then monitor the effectiveness of your cache settings using [Cache Analytics](https://developers.cloudflare.com/cache/performance-review/cache-analytics/) and update your configuration according to our [Cache performance guide](https://developers.cloudflare.com/cache/performance-review/cache-performance/).

### Advanced cache optimizations

* [Custom Cache Keys](https://developers.cloudflare.com/cache/how-to/cache-keys/) allows you to precisely set the cacheability setting for any resource.
* [Origin Cache Control](https://developers.cloudflare.com/cache/concepts/cache-control/) can be used to let the Cache-Control headers tell Cloudflare how to handle content from the origin server.

## Tiered Cache

[Tiered Cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/) uses the size of Cloudflare's network to reduce requests to customer origin servers by dramatically increasing cache hit ratios.

It works by dividing Cloudflare's data centers into a hierarchy of lower-tiers and upper-tiers. If content is not cached in lower-tier data centers (generally the ones closest to a visitor), the lower-tier requests an upper-tier for the content. If the upper-tier does not have the content, only the upper-tier will initiate a request to the origin. This practice improves bandwidth efficiency by limiting the number of Cloudflare data centers that can ask the origin for content.

Refer to [Enable Tiered Cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/#enable-tiered-cache) to get started.

### Cache Reserve

[Cache Reserve](https://developers.cloudflare.com/cache/advanced-configuration/cache-reserve/) is a large, persistent data store implemented on top of [R2](https://developers.cloudflare.com/r2/).

With a single click in the dashboard, your cacheable content will be written to Cache Reserve. In the same way that Tiered Cache builds a hierarchy of caches between your visitors and your origin, Cache Reserve serves as the ultimate [upper-tier cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/) that will reserve storage space for your assets for as long as you want.

This ensures that your content is served from cache longer, shielding your origin from unneeded egress fees.

## Cloudflare Waiting Room

[Cloudflare Waiting Room](https://developers.cloudflare.com/waiting-room/) allows you to route excess users of your website to a customized waiting room, helping preserve customer experience and protect origin servers from being overwhelmed with requests.

## Use Cloudflare IP addresses

Take action to prevent attacks to your application during peak season by configuring your firewall to only accept traffic from Cloudflare IP addresses. By only allowing [Cloudflare IPs](https://www.cloudflare.com/ips), you can prevent attackers from bypassing Cloudflare and sending requests directly to your origin.

Refer to [Cloudflare IP addresses](https://developers.cloudflare.com/fundamentals/concepts/cloudflare-ip-addresses/) for more information.

## Monitor traffic

You can use the Cloudflare dashboard to closely monitor the traffic on your domain and fine-tune your cache and security settings accordingly.

### Zone and Account analytics

[Cloudflare zone analytics](https://developers.cloudflare.com/analytics/account-and-zone-analytics/zone-analytics/) gives you access to a wide range of metrics, collected at the website or domain level.

[Cloudflare account analytics](https://developers.cloudflare.com/analytics/account-and-zone-analytics/account-analytics/) lets you access a wide range of aggregated metrics from all the sites under a specific Cloudflare account.

### Security Analytics and Security Events

[Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/) displays information about all incoming HTTP requests for your domain, including requests not handled by Cloudflare security products.

You can also use the [Security Events](https://developers.cloudflare.com/waf/analytics/security-events/) to review mitigated requests and tailor your security configurations.

### Cache Analytics

You can use [Cache Analytics](https://developers.cloudflare.com/cache/performance-review/cache-analytics/) to improve site performance or reduce origin web server traffic. Cache Analytics helps determine if resources are missing from cache, expired, or ineligible for caching.
